/*    
 ADF-Copy Frontend - Copyright (C) 2019 Dominik Tonn (nick@niteto.de)
 visit http://nicklabor.niteto.de for Infos and Updates
 
 This program is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

boolean HD_allowed = true;

String version = "v1.010";
Float minVer = 1.010;
String firmware = "unknown";
//import com.fazecast.jSerialComm.*;
import java.io.DataOutputStream;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
//import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Date;
import java.awt.*;
import java.time.LocalDateTime;
import java.sql.Timestamp;
import java.time.Year;

String fileName = "test.adf"; // fill in
String filePath = "";
String diskName = "ADF-Copy";

import processing.serial.*;
import g4p_controls.*;
import static javax.swing.JOptionPane.*;
import jssc.*;


int bgcolor;			     // Background color
int fgcolor;			     // Fill color
Serial myPort;                       // The serial port
byte[] readString = new byte[512*11];
int readPtr;
long errormap[] = new long[160];
byte bitMapArray[] = new byte[2*1760];
int bitMapSize = 0;
volatile color trackmap[] = new color[160]; 
int weak[] = new int[160];
boolean abort = false;
String extError;
int lf = 10;
byte track[] = new byte[512*22];
byte trackComp[] = new byte[512*22];
long hist[][] = new long [160][256];
boolean verify = false;
PGraphics upperGrid;
PGraphics lowerGrid;
PGraphics flux;
PGraphics progress;
PGraphics status;
PGraphics active;
PGraphics logo;
PGraphics diskImage;
PGraphics diskinfo;
PGraphics bitmap; 
PImage checkmark;
PImage disk;
boolean diskChange = false;
boolean autoFormatDisks = false;
boolean preErase = true;
int k = 0;
boolean ignoreChksumErr = true;
int mode = 0; // 0 = DD, 1 = HD
String pName;
String fileSep;
long motorSpinupDelay;
long motorSpindownDelay;
long driveSelectDelay;
long driveDeselectDelay;
long setDirDelay;
long setSideDelay;
long stepDelay;
long stepSettleDelay;
long gotoTrackSettle;

int activePanel = -1;

Font myFont;
String myFontName = "RobotoCondensed-Regular.ttf";
//String myFontName = "IndieFlower.ttf";
Float myFontSize = 13.0;
PFont myPFont;

void exit() {
  if (myPort!=null) {
    myPort.write("nobusy\n");
    myPort.write("mtp\n");
    myPort.clear();
  } 
  println("exiting program...");
  super.exit();
}

void setup() {
  size(600, 520, JAVA2D);  // Stage size
  //size(1000, 520, JAVA2D);  // Stage size
  println("\n------------------------------------------------------------");
  println("ADF-Copy App - Frontend to Read and Write Amiga Floppy Disks");
  println("Copyright (C) 2019 Dominik Tonn (nick@niteto.de)");
  println("visit http://nicklabor.niteto.de for Infos and Updates");
  println("------------------------------------------------------------\n");
  int discard, major, minor, update, build;

  String[] javaVersionElements = System.getProperty("java.runtime.version").split("\\.|_|-|-b");

  major   = Integer.parseInt(javaVersionElements[1]);
  minor   = Integer.parseInt(javaVersionElements[2]);
  update  = Integer.parseInt(javaVersionElements[3]);

  println("Java: " + System.getProperty("java.runtime.version"));
  println("Java: " + System.getProperty("java.awt.version"));
  boolean javaWarn = false;
  if (major!=8) javaWarn = true;
  if ((minor==0)&&(update<200))javaWarn = true;
  if (javaWarn) showMessageDialog(frame, "This application requires Java Version 8 Update 2xx or later.\n" +
    "Consider updating your Java to newest Version 8 if you experience problems.", 
    "Current Java Version "+System.getProperty("java.runtime.version")+".", INFORMATION_MESSAGE);

  smooth(1);
  for (int i = 0; i<160; i++) {
    trackmap[i]=#ffffff;
  }
  int waitCounter = 0;
  surface.setTitle(version+": Loading Checkmark Image");
  checkmark = null;
  while (checkmark == null) {
    checkmark = loadImage("checkmark.png");
    waitCounter++;
    if (checkmark == null) delay(1000);
    if (waitCounter==10) {
      showMessageDialog(frame, "Unable to load checkmark image");
      System.exit(0);
    }
  }
  waitCounter = 0;
  surface.setTitle(version+": Loading InsertDisk Image");
  disk = null;
  while (disk == null) {
    disk = loadImage("InsertDisk.png");
    waitCounter++;
    if (disk == null) delay(1000);
    if (waitCounter==10) {
      showMessageDialog(frame, "Unable to load InsertDisk image");
      System.exit(0);
    }
  }
  upperGrid = createGraphics(170, 160);
  lowerGrid = createGraphics(170, 160);
  flux = createGraphics(360, 360);
  progress = createGraphics(160, 10);
  active = createGraphics(20, 150);
  status = createGraphics(370, 20);
  logo = createGraphics(170, 127);
  diskinfo = createGraphics(170, 100);
  bitmap = createGraphics(160, 44);
  drawBitmap(bitmap, true);
  diskImage = createGraphics(130, 131);
  diskImage.beginDraw();
  diskImage.image(disk, 0, 0);
  diskImage.endDraw();
  drawLogo(logo);
  drawProgress(progress, -1);
  grid(upperGrid, 0);
  grid(lowerGrid, 1);
  drawFlux(flux);
  /*
  com.fazecast.jSerialComm.SerialPort comPort[] = com.fazecast.jSerialComm.SerialPort.getCommPorts();
   for (int i = 0; i<comPort.length; i++) {
   print(comPort[i].getDescriptivePortName());
   print(" - ");
   print(comPort[i].getSystemPortName());
   print("\n");
   }
   */
  firmware = "ADF-Drive/Copy hardware not found";
  float firmwareVersion = (float)9.999;
  initSerial();
  if (myPort!=null)
  {
    myPort.write("init\n");
    delay(200);
    myPort.clear();
    while (myPort.available()!=0) {
      print(myPort.readChar());
      delay(10);
    }
    surface.setTitle(version+": Connecting to Hardware...");
    myPort.write("ver\n");
    int timeout = 40;
    while (myPort.available()==0) {
      delay(100);
      surface.setTitle(version+": Connecting to Hardware... "+timeout);
      timeout--;
      if (timeout<=0) {
        showMessageDialog(frame, "Communication timed out, please try again.", "Timeout", INFORMATION_MESSAGE);
        System.exit(0);
      }
    }
    firmware = myPort.readString();
    String tempVer = firmware.substring(firmware.lastIndexOf("Firmware v")+10);
    firmwareVersion = Float.valueOf(tempVer.substring(0, tempVer.indexOf(" ")));
  }

  surface.setTitle(version+": Creating GUI");
  createGUI();
  try {
    myFont = java.awt.Font.createFont(Font.TRUETYPE_FONT, new File(dataPath("")+fileSep+myFontName)).deriveFont(myFontSize);
    GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
    //register the font
    ge.registerFont(Font.createFont(Font.TRUETYPE_FONT, new File(dataPath("")+fileSep+myFontName)));
  } 
  catch (IOException e) {
    e.printStackTrace();
  } 
  catch (FontFormatException e) {
    e.printStackTrace();
  }
  myPFont = createFont(myFontName, 14f);
  drawStatus(status, firmware);
  filename.setFont(myFont);
  filepathandname.setFont(myFont);
  label3.setFont(myFont);
  label4.setFont(myFont);
  label2.setFont(myFont);
  label5.setFont(myFont);
  label6.setFont(myFont);
  verifyCheck.setFont(myFont);
  timeLabel.setFont(myFont);
  aboutP.setFont(myFont);
  aboutP.moveTo(10, 10);
  closeB.setFont(myFont);
  LoadSettings.setFont(myFont); 
  TestSettings.setFont(myFont); 
  SaveSettings.setFont(myFont); 
  MotorSpinup_.setFont(myFont); 
  MotorSpindown_.setFont(myFont); 
  DriveSelect_.setFont(myFont); 
  DriveDeselect_.setFont(myFont); 
  DirChange_.setFont(myFont); 
  spinup.setFont(myFont); 
  SideChange_.setFont(myFont); 
  StepPulse_.setFont(myFont); 
  StepSettle_.setFont(myFont); 
  GotoTrack_.setFont(myFont); 
  Spindown.setFont(myFont); 
  DriveSelect.setFont(myFont); 
  DriveDeselect.setFont(myFont); 
  DirChange.setFont(myFont); 
  SideChange.setFont(myFont); 
  StepPulse.setFont(myFont); 
  StepSettle.setFont(myFont); 
  gotoTrack.setFont(myFont); 
  MtpOn.setFont(myFont); 
  reset2DefaultSettings.setFont(myFont);

  ReadPanel.moveTo(120, -20);
  ReadPanel.setVisible(true);
  WritePanel.moveTo(120, -20);
  WritePanel.setVisible(false);
  UtilityPanel.moveTo(120, -20);
  UtilityPanel.setVisible(false);
  SettingsPanel.moveTo(120, 10);
  SettingsPanel.setVisible(false);
  drawActive(active, 0);

  chkSumChk.setFont(myFont);
  GButton.useRoundCorners(false);
  GCScheme.changePaletteColor(10, 2, color(150));
  GCScheme.changePaletteColor(10, 3, color(230));
  GCScheme.changePaletteColor(10, 4, color(200));
  GCScheme.changePaletteColor(10, 6, color(200));
  GCScheme.changePaletteColor(10, 14, color(200));
  color lightBlue = color(#ccccff);
  color darkBlue = color(#0b0b60);
  GCScheme.changePaletteColor(11, 2, color(50));
  GCScheme.changePaletteColor(11, 3, darkBlue);
  GCScheme.changePaletteColor(11, 4, lightBlue);
  GCScheme.changePaletteColor(11, 6, lightBlue);
  GCScheme.changePaletteColor(11, 14, lightBlue);
  closeB.setLocalColorScheme(11);
  enableButtons(false, false);
  aboutP.setVisible(false);
  diskPanel.setVisible(false);
  filename.setTextEditEnabled(false);
  filepathandname.setTextEditEnabled(false);
  aboutText.setTextEditEnabled(false);
  aboutText.setFont(myFont);
  //  aboutText.textSize(14);  
  aboutText.setText(
    "ADF-Copy App - Frontend to Read and Write Amiga Floppy Disks\n"+
    "Copyright (C) 2019 Dominik Tonn (nick@niteto.de)\n"+
    " \n"+                    
    "visit http://nicklabor.niteto.de for Infos and Updates\n"+
    "send me an e-mail if you want to order a pcb.\n"+
    " \n"+                    
    "This program is free software: you can redistribute it and/or modify "+
    "it under the terms of the GNU General Public License as published by "+
    "the Free Software Foundation, either version 3 of the License, or "+
    "(at your option) any later version.\n"+
    " \n"+
    "This program is distributed in the hope that it will be useful, "+
    "but WITHOUT ANY WARRANTY; without even the implied warranty of "+
    "MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the "+
    "GNU General Public License for more details.\n"+
    " \n"+
    "You should have received a copy of the GNU General Public License "+
    "along with this program.  \nIf not, see http://www.gnu.org/licenses/");
  surface.setIcon(checkmark);
  diskInfo(true);
  if (firmwareVersion < minVer) showMessageDialog(frame, "This application requires firmware " + String.format("%.3f",minVer) + " or later.", "Firmware", INFORMATION_MESSAGE);
  if (myPort==null) {
    disableButtons();
    enableButtons(false, false);
    enableButton(About);
  }
}

void grid(PGraphics thisGrid, int side)
{
  int x = 15;
  int y = 15;
  thisGrid.beginDraw();
  thisGrid.background(230);
  thisGrid.stroke(0);
  thisGrid.textSize(14);
  thisGrid.textAlign(CENTER, CENTER);
  int size = 15;
  for (int i = 0; i<8; i++) {
    for (int j = 0; j<10; j++) {
      if (i==0) {
        thisGrid.fill(0, 0, 0);
        thisGrid.text(j, x+size/2+j*size, y-size/2-2);
        thisGrid.fill(255, 255, 255);
      }
      thisGrid.fill(trackmap[(j+i*10)*2+side]);
      //println(j+i*10);
      thisGrid.rect(x+j*size, y+i*size, size, size, 3);
      thisGrid.fill(255, 255, 255);
    }
    thisGrid.fill(0, 0, 0);
    thisGrid.text(i, x-size/2, size+y-size/2+i*size);
    thisGrid.fill(255, 255, 255);
  }
  thisGrid.fill(0, 0, 0);
  if (side==0) {
    thisGrid.text("Upper Side", x+75, y+130);
  } else {
    thisGrid.text("Lower Side", x+75, y+130);
  }
  thisGrid.fill(255, 255, 255);
  thisGrid.endDraw();
}

void draw() {
  surface.setTitle("ADF-Copy "+version);
  background(230);
  sP1.setGraphic(upperGrid);
  sP2.setGraphic(lowerGrid);
  fluxPad.setGraphic(flux);
  progressPad.setGraphic(progress);
  activePad.setGraphic(active);
  statusPad.setGraphic(status);
  DiskInfoPad.setGraphic(diskinfo);
  bitmapPad.setGraphic(bitmap);
  logoPad.setGraphic(logo);
  diskPad.setGraphic(diskImage);
  sP1.draw();
  sP2.draw();
  fluxPad.draw();
  progressPad.draw();
  statusPad.draw();
  DiskInfoPad.draw();
  logoPad.draw();
}

String getExtErr()
{
  myPort.clear();
  myPort.write("exterr\n");
  while (myPort.available()==0) {
    delay(5);
  }
  return myPort.readString();
}

String getSettings()
{
  myPort.clear();
  myPort.write("getsettings\n");
  while (myPort.available()==0) {
    delay(5);
  }
  String temp = myPort.readStringUntil(lf);
  String[] array = temp.split("\\ ");
  /*  for (int i=0; i<array.length; i++) {
   print(i, ": ");
   println(array[i]);
   }*/
  if (myPort.readString().contains("OK"))
  {
    MotorSpinup_.setText((array[0]));
    MotorSpindown_.setText((array[1]));
    DriveSelect_.setText((array[2]));
    DriveDeselect_.setText((array[3]));
    DirChange_.setText((array[4]));
    SideChange_.setText((array[5]));
    StepPulse_.setText((array[6]));
    StepSettle_.setText((array[7]));
    GotoTrack_.setText((array[8]));
    sdRetries_.setText((array[9]));
    hdRetries_.setText((array[10]));
    if (Integer.parseInt(array[11])==0) mtpMode_.setSelected(false);
    else mtpMode_.setSelected(true);
    drawStatus(status, "Settings read from Drive...");
    return "ok";
  } else {
    drawStatus(status, "Reading Settings failed.");    
    return "failed";
  }
}

String setSettings()
{
  myPort.clear();
  String settimingsCmd =  "setsettings " +
    MotorSpinup_.getText() + " " + 
    MotorSpindown_.getText() + " " + 
    DriveSelect_.getText() + " " + 
    DriveDeselect_.getText() + " " + 
    DirChange_.getText() + " " + 
    SideChange_.getText() + " " + 
    StepPulse_.getText() + " " + 
    StepSettle_.getText() + " " + 
    GotoTrack_.getText()+ " " +
    sdRetries_.getText() + " " + 
    hdRetries_.getText() + " ";
  if (mtpMode_.isSelected()) settimingsCmd=settimingsCmd + "1 ";
  else settimingsCmd=settimingsCmd + "0 ";
  settimingsCmd = settimingsCmd +
    0xDEADDA7A + " " +
    0xDEADDA7A + " " +
    0xDEADDA7A + " " +
    0xDEADDA7A + " " +
    0xDEADDA7A + "\n";


  myPort.write(settimingsCmd);
  while (myPort.available()==0) {
    delay(5);
  }
  if (myPort.readString().contains("OK"))
  {
    drawStatus(status, "Settings written to RAM...");
    return "ok";
  } else {
    drawStatus(status, "Saving Settings failed.");    
    return "failed";
  }
}

String storeSettings()
{
  myPort.clear();
  myPort.write("storesettings\n");
  while (myPort.available()==0) {
    delay(5);
  }
  if (myPort.readString().contains("OK"))
  {
    drawStatus(status, "Settings written to RAM & EEPROM...");
    return "ok";
  } else {
    drawStatus(status, "Storing Settings failed.");    
    return "failed";
  }
}

String resetSettings()
{
  myPort.clear();
  myPort.write("resetsettings\n");
  while (myPort.available()==0) {
    delay(5);
  }
  if (myPort.readString().contains("OK"))
  {
    myPort.clear();
    myPort.write("storesettings\n");
    while (myPort.available()==0) {
      delay(5);
    }
    if (myPort.readString().contains("OK")) {
      drawStatus(status, "default values written to EEPROM ...");
      return "ok";
    } else {
      drawStatus(status, "Storing Settings failed.");    
      return "failed";
    }
  } else {
    drawStatus(status, "Storing Settings failed.");    
    return "failed";
  }
}

void diskInfo(boolean blank)
{
  String temp ="";
  if (!blank) {
    myPort.clear();
    myPort.write("diskinfo\n");
    while (myPort.available()==0) {
      delay(5);
    }
    String buf;
    while (!temp.endsWith("OK\r\n")) {
      buf = myPort.readString();
      if (buf!=null) temp = temp + buf;
      delay(5);
    }
    String [] array = new String[20];
    String [] tempArray = temp.split("\\r?\\n");
    for (int i = 0; i<20; i++) array[i] = "Info: NA";  
    for (int i = 0; i<tempArray.length; i++) array[i] = tempArray[i];  
    array[0] = array[0].substring(array[0].indexOf(": ")+2); // Bootchecksum
    array[1] = array[1].substring(array[1].indexOf(": ")+2); // Rootblock
    array[2] = array[2].substring(array[2].indexOf(": ")+2); // Filesystem
    array[3] = array[3].substring(array[3].indexOf(": ")+2); // RootblockType
    array[4] = array[4].substring(array[4].indexOf(": ")+2); // RootblockChecksum
    array[5] = array[5].substring(array[5].indexOf(": ")+2); // Name
    array[6] = array[6].substring(array[6].indexOf(": ")+2); // Modified
    array[7] = array[7].substring(array[7].indexOf(": ")+2); // Created
    array[8] = array[8].substring(array[8].indexOf(": ")+2); // BM Checksum
    array[9] = array[9].substring(array[9].indexOf(": ")+2); // Blocks free
    filename.setText("\""+array[5]+"\"");
    fileName=array[5].replaceAll("[#<>$+%!´`&*\"|{}?=/:\\@]", "_")+".adf";
    diskinfo.beginDraw();
    diskinfo.background(255);
    diskinfo.textFont(myPFont);
    diskinfo.textSize(12);
    diskinfo.fill(80, 80, 255);
    diskinfo.text("BootBlock", 1, 12);
    diskinfo.fill(0);
    diskinfo.text("FS:", 85, 12);
    diskinfo.text(array[2], 105, 12);
    diskinfo.text("RootPtr:", 1, 26);
    diskinfo.text(array[1], 50, 26);
    diskinfo.text("BBChksum:", 85, 26);
    if (array[0].contains("Valid")) diskinfo.fill(0, 255, 0);
    else diskinfo.fill(255, 0, 0);
    diskinfo.ellipse(155, 21, 10, 10);
    diskinfo.fill(0);
    diskinfo.line(5, 29, 165, 29);

    diskinfo.fill(80, 80, 255);
    diskinfo.text("RootBlock", 1, 42);
    diskinfo.fill(0);
    diskinfo.text("BlkType OK:", 85, 42);
    if (array[3].contains("Valid")) diskinfo.fill(0, 255, 0);
    else diskinfo.fill(255, 0, 0);
    diskinfo.ellipse(155, 37, 10, 10);
    diskinfo.fill(0);
    diskinfo.text("RBChksum:", 1, 56);
    if (array[4].contains("Valid")) diskinfo.fill(0, 255, 0);
    else diskinfo.fill(255, 0, 0);
    diskinfo.ellipse(70, 51, 10, 10);
    diskinfo.fill(0);
    diskinfo.text("BMChksum:", 85, 56);
    if (array[8].contains("Valid")) diskinfo.fill(0, 255, 0);
    else diskinfo.fill(255, 0, 0);
    diskinfo.ellipse(155, 51, 10, 10);
    diskinfo.fill(0);
    diskinfo.text("Created:", 1, 70);
    diskinfo.text(array[7], 62, 70);
    diskinfo.text("Modified:", 1, 84);
    diskinfo.text(array[6], 62, 84);
    diskinfo.text("Blocks Free:", 1, 98);
    diskinfo.text(array[9], 62, 98);

    for (int i = 0; i<tempArray.length-1; i++)
    {
      //    diskinfo.text(array[i], 2, 10*(i+1));
    }
    diskinfo.endDraw();
    getBitmap();
    drawBitmap(bitmap, false);
  } else {
    diskinfo.beginDraw();
    diskinfo.background(255);
    diskinfo.textFont(myPFont);
    diskinfo.textSize(20);
    diskinfo.fill(80, 80, 255);
    diskinfo.text("Insert Disk", 2, 25);
    diskinfo.text("and press", 2, 55);
    diskinfo.text("Diskinfo", 2, 85);
    diskinfo.endDraw();
  }
}
int probeDisk()
{
  myPort.clear();
  myPort.write("probe 1\n");
  while (myPort.available()==0) {
    delay(5);
  }
  String retString = myPort.readString();
  int ret =0;
  if (retString.charAt(0)=='2') ret = 2;
  if (retString.charAt(0)=='1') ret = 1;
  if (retString.charAt(0)=='0') ret = 0;
  if (retString.charAt(0)=='-') ret = -1;
  return ret;
}


int getMode()
{
  myPort.clear();
  myPort.write("getmode\n");
  while (myPort.available()==0) {
    delay(5);
  }
  if (myPort.readString().charAt(0) =='H') {
    mode = 1;
  } else {
    mode = 0;
  }
  return mode;
}
char byte2char(byte c) {
  if ((c < 32) | (c > 126)) {
    return (char) 46;
  } else {
    return (char) c;
  }
}
void getWeak(int track)
{
  myPort.clear();
  myPort.write("weak\n");
  while (myPort.available()==0) {
    delay(5);
  }
  weak[track] = myPort.read();
  if (weak[track] > 2) {
    //    println("Track: "+track+" Retries: "+weak[track]);
    trackmap[track]=#ffff00;
  } else {
    trackmap[track]=#00ff00;
  }
}

void getFlux(int track)
{
  long a, b, c, d;
  long tHist;
  myPort.clear();
  myPort.write("flux\n");
  while (myPort.available()<1024) {
    delay(5);
  }
  for (int i = 0; i<256; i++) {
    a = myPort.read();
    b = myPort.read();
    c = myPort.read();
    d = myPort.read();
    tHist = (d<<24)+(c<<16)+(b<<8)+a;
    hist[track][i]=tHist;
  }
}

void getBitmap()
{
  if (getMode()==0) bitMapSize = 1760;
  else bitMapSize = 2*1760;

  myPort.clear();
  myPort.write("bitmap\n");
  while (myPort.available()==0) {
    delay(5);
  }
  for (int i= 0; i<bitMapSize; i++) {
    if (myPort.readChar()=='0') bitMapArray[i]=0;
    else bitMapArray[i]=1;
  }
  myPort.clear();
}

void drawBitmap(PGraphics tP, boolean empty)
{
  tP.beginDraw();
  if (empty) {
    tP.fill(255, 255, 255, 255);
    tP.noStroke();
    tP.rect(0, 0, 159, 44);
    tP.fill(0, 255, 0, 255);
  } else
  {
    tP.noStroke();
    for (int i = 0; i<bitMapSize; i++)
    {
      if (bitMapArray[i] == 0) tP.fill(255, 0, 0);
      else tP.fill(0, 255, 0);
      if (bitMapSize==1760) tP.rect(i/22*2, (i%22)*2, 2, 2);
      else tP.rect(i/44*2, i%44, 2, 1);
    }
  }
  tP.endDraw();
}

void drawProgress(PGraphics tP, int i)
{
  tP.beginDraw();
  tP.fill(255, 255, 255, 255);
  tP.noStroke();
  tP.rect(0, 0, 159, 9);
  tP.fill(0, 255, 0, 255);
  tP.noStroke();
  tP.rect(0, 0, i, 9);
  tP.endDraw();
}

void drawActive(PGraphics tP, int i)
{
  ReadPanel.moveTo(800, -20);
  WritePanel.moveTo(800, -20);
  UtilityPanel.moveTo(800, -20);
  SettingsPanel.moveTo(800, 10);
  /*
  ReadPanel.setVisible(false);
   WritePanel.setVisible(false);
   UtilityPanel.setVisible(false);
   SettingsPanel.setVisible(false);
   */
  switch (i) {
  case 0:
    ReadPanel.setVisible(true);
    ReadPanel.moveTo(120, -20);
    break;
  case 1:
    WritePanel.setVisible(true);
    WritePanel.moveTo(120, -20);
    break;
  case 2:
    UtilityPanel.setVisible(true);
    UtilityPanel.moveTo(120, -20);
    break;
  case 3:
    SettingsPanel.setVisible(true);
    SettingsPanel.moveTo(120, 10);
    break;
  default:
  }
  if (i>=0 ) activePanel = i;
  tP.beginDraw();
  tP.clear();
  tP.fill(0, 0, 255, 128);
  tP.noStroke();
  if (i>=0) tP.rect(0, 0+(40*i), 20, 30, 0, 5, 5, 0);
  tP.endDraw();
}

void drawStatus(PGraphics tS, String text)
{
  if (text==null) text="Unknown Error";
  tS.beginDraw();
  tS.background(255);
  tS.textFont(myPFont);
  //  tS.textSize(12);
  tS.fill(0);
  tS.text(text, 2, 15);
  tS.endDraw();
}

void drawLogo(PGraphics tL)
{
  PImage img;
  PImage img2;
  int waitCounter = 0;
  surface.setTitle(version+": Loading Logo");
  img = null;
  while (img == null) {
    img = loadImage("logoblau.jpg");
    waitCounter++;
    if (img == null) delay(1000);
    if (waitCounter==10) {
      showMessageDialog(frame, "Unable to load Logo image");
      System.exit(0);
    }
  }
  waitCounter = 0;
  surface.setTitle(version+": Loading GPL-Logo");
  img2 = null;
  while (img2 == null) {
    img2 = loadImage("gplv3.png");
    waitCounter++;
    if (img2 == null) delay(1000);
    if (waitCounter==10) {
      showMessageDialog(frame, "Unable to load GPL image");
      System.exit(0);
    }
  }
  tL.beginDraw();
  //tL.background(255);
  tL.image(img, 0, 0);
  tL.image(img2, 70, 97, 100, 30);
  tL.textSize(14);
  tL.textAlign(CENTER, CENTER);
  tL.fill(255);
  tL.text(version, 35, 115);
  tL.fill(0, 0, 0, 0);
  tL.stroke(230);
  tL.strokeWeight(4);
  tL.rect(-1, -1, 172, 129, 10);
  tL.endDraw();
}

void drawFlux(PGraphics tF)
{
  tF.beginDraw();
  tF.background(230);
  long tHist;
  tF.fill(0, 102, 153);
  tF.stroke(0, 0, 0);
  tF.line(29, 331, 350, 331);
  tF.line(29, 331, 29, 28);
  tF.textSize(20);
  tF.textAlign(RIGHT, CENTER);
  tF.text("µs", 40, 400-2*199);
  tF.text("8", 20, 400-2*186);
  tF.line(24, 401-2*186, 34, 401-2*186);
  tF.text("6", 20, 400-2*138);
  tF.line(24, 401-2*138, 34, 401-2*138);
  tF.text("4", 20, 400-2*90);
  tF.line(24, 401-2*90, 34, 401-2*90);
  tF.textAlign(CENTER, CENTER);
  tF.text("0", 30, 340);
  tF.text("40", 180, 340);
  tF.text("79", 340, 340);
  //rect(40, 360, 320, 280, 7);
  for (int j =0; j<160; j++) {
    if (weak[j]>0) {
      if (weak[j]==25) {
        tF.stroke(255, 0, 0);
      } else {
        tF.stroke(180, 180-weak[j]*30, 180);
      }
      tF.line(30+j*2, 330, 30+j*2, 30);
    }
    for (int i = 50; i<200; i++) {
      tHist=hist[j][i];
      if (tHist>0) {
        tF.stroke(tHist/2, tHist/8, tHist/64);
        tF.rect(30+j*2, 400-i*2, 1, 1);
        //        point(40+j*2, 240+i*2);
        //        point(40+j*2+1, 240+i*2);
      }
    }
  }
  tF.endDraw();
}

void readSelected(File selection) {
  if (selection == null) {
    println("Window was closed or the user hit cancel.");
    disableButton(StartRead);
  } else {
    println("User selected " + selection.getAbsolutePath());
    fileName=selection.getAbsolutePath();
    filepathandname.setText(fileName);
    disableButton(StartWrite);
    enableButton(StartRead);
  }
}

void folderSelected(File selection) {
  if (selection == null) {
    println("Window was closed or the user hit cancel.");
  } else {
    println("User selected " + selection.getAbsolutePath());
    filePath=selection.getAbsolutePath();
    filepathandname.setText(filePath);
    myPort.write("init\n");
    myPort.clear();
    thread("autoRip");
  }
}

void writeSelected(File selection) {
  if (selection == null) {
    println("Window was closed or the user hit cancel.");
    disableButton(StartWrite);
  } else {
    println("User selected " + selection.getAbsolutePath());
    fileName=selection.getAbsolutePath();
    filepathandname.setText(fileName);
    disableButton(StartRead);
    enableButton(StartWrite);
  }
}

void enableButton(GImageButton button)
{
  button.setEnabled(true);
  button.setAlpha(255);
}

void disableButton(GImageButton button)
{
  button.setEnabled(false);
  button.setAlpha(50);
}

void disableButtons()
{
  if (myPort!=null) enableButton(Abort);
  disableButton(ReadButton);
  disableButton(WriteButton);
  disableButton(UtilityButton);
  disableButton(SettingsButton);
  disableButton(About);
  disableButton(Init);
  disableButton(GetDiskInfo);

  disableButton(ReadDisk);
  disableButton(compareDisk);
  disableButton(AutoRip);
  disableButton(StartRead);

  disableButton(WriteDisk);
  disableButton(AutoWrite);
  disableButton(StartWrite);

  disableButton(Format);
  disableButton(AutoFormat);
  disableButton(Cleaning);
  dropList2.setEnabled(false);
  dropList2.setAlpha(50);
}

void enableButtons(boolean read, boolean write)
{
  if (myPort==null) {
    enableButton(ReadButton);
    enableButton(WriteButton);
    enableButton(UtilityButton);
    enableButton(About);
    disableButton(Abort);
  } else
  {
    disableButton(Abort);
    enableButton(ReadButton);
    enableButton(WriteButton);
    enableButton(UtilityButton);
    enableButton(SettingsButton);
    enableButton(About);
    enableButton(GetDiskInfo);
    enableButton(Init);

    enableButton(ReadDisk);
    enableButton(compareDisk);
    enableButton(AutoRip);
    if (read) enableButton(StartRead);
    else disableButton(StartRead);

    enableButton(WriteDisk);
    enableButton(AutoWrite);
    if (write) enableButton(StartWrite);
    else disableButton(StartWrite);

    enableButton(Format);
    enableButton(AutoFormat);
    enableButton(Cleaning);
    dropList2.setEnabled(true);
    dropList2.setAlpha(255);
  }
}

void getTracks()
{
  ignoreChksumErr=chkSumChk.isSelected();
  abort = false;
  disableButtons();
  for (int i = 0; i<160; i++)
  {
    weak[i]=0;
    errormap[i]=0;
    trackmap[i]=#ffffff;
    for ( int j=0; j<256; j++) {
      hist[i][j]=0;
    }
  }
  int start = 0;
  int stop = 160;
  int zeit = millis();
  long errors = 0;
  int failed = 0;
  String tempString;
  boolean retry = false;
  int sectors = 11;
  String extError;
  myPort.clear();
  try {
    FileOutputStream fstream = new FileOutputStream(fileName);
    BufferedOutputStream bstream = new BufferedOutputStream(fstream);
    DataOutputStream dstream = new DataOutputStream(bstream);
    drawStatus(status, "Reading Tracks...");

    for (int i = start; i<stop; i++) {
      if (abort==true) {
        //abort = false;
        drawStatus(status, "Aborting by User request...");
        break;
      }
      drawProgress(progress, i);
      myPort.write("get "+i+"\n");
      //println("error");
      myPort.write("error\n");
      while (myPort.available()==0) {
        delay(5);
      }
      tempString = trim(myPort.readString());
      errormap[i] = Long.parseLong(tempString);
      if (errormap[i]==-1) {
        extError = getExtErr();
        drawStatus(status, "Fatal Error Track " + i+ ": "+extError);
        if (showConfirmDialog(frame, "Retry?", extError+" at Track "+i, YES_NO_OPTION)==1)
        {
          failed = -1;
          break;
        } else {
          retry = true;
        }
      }       
      //      myPort.clear();
      //println("weak");
      getWeak(i);
      drawStatus(status, "Track: " + i+" Errors: "+errors);
      if (errormap[i]!=0) {
        errors++;
        trackmap[i]=#ff0000;
        if (ignoreChksumErr==false) {
          if (showConfirmDialog(frame, "Retry?", "Checksum error at Track "+i, YES_NO_OPTION)!=1)
          {
            retry = true;
          }
        }
      }
      //println("dump");
      getFlux(i);
      grid(upperGrid, 0);
      grid(lowerGrid, 1);
      drawFlux(flux);
      if (getMode()==1) {
        sectors=22;
      } else {
        sectors=11;
      }

      myPort.write("download\n");
      while (myPort.available()<512*sectors) {
        delay(10);
      }
      track = myPort.readBytes();

      if (retry==false) dstream.write(track, 0, 512*sectors);
      timeLabel.setText("Time remaining: "+((millis()-zeit)*160/(i+1)-(millis()-zeit))/1000+"s");
      //println("flux");
      if (retry) {
        i--;
        retry = false;
      }
    }
    dstream.close();
    zeit = millis()-zeit;
    if (failed == 0) {
      drawStatus(status, "Download complete. "+(stop-start)+" Tracks read in "+(zeit/1000)+" Seconds");
      PrintWriter logFile;
      logFile = createWriter(fileName+".log");
      for (int i = start; i<stop; i++) {
        if ((errormap[i]!=0) || (weak[i]>1)) {
          logFile.print("Cyl: " + floor(i/2) + " Head: " + i%2 + " - ");
        }
        if (errormap[i]!=0) {
          logFile.println("Bad Track #"+i+parseError(errormap[i]));
        }
        if ((weak[i]>1)&&(errormap[i]==0)) {
          logFile.println("possible Weak Track #"+i+", needed "+weak[i]+" retries.");
        }
      }
      logFile.flush();
      logFile.close();
      noLoop();
      redraw();
      flux.save(fileName+".jpg");
      loop();
      timeLabel.setText("Done");
    }
  }   
  catch(IOException e) {
    println("IOException");
    e.printStackTrace();
  }
  enableButtons(true, false);
  myPort.write("init\n");
}

void cleanDrive()
{
  abort = false;
  disableButtons();
  myPort.clear();
  for (int i = 0; i<160; i++)
  {
    trackmap[i]=#ffffff;
  }
  String temp = dropList2.getSelectedText();
  temp = temp.replace(" sec", "");
  int tDuration = int(temp);
  int i = 0;
  int secs= 0;
  int zeit = millis();
  drawStatus(status, "Moving Head around...");
  int duration = zeit + tDuration*1000;
  while (duration > millis()) {
    if (abort==true) {
      abort = false;
      drawStatus(status, "Aborting by User request...");
      break;
    }
    trackmap[i*2]=#00ffff;
    trackmap[i*2+1]=#00ffff;
    myPort.write("goto "+i*2+"\n");
    drawStatus(status, "Track: " + i);
    i = (i + 6)%80;
    grid(upperGrid, 0);
    grid(lowerGrid, 1);
    secs = (duration - millis())/1000;
    timeLabel.setText("Time remaining: "+secs+"s");
    drawProgress(progress, int(160-(160/float(tDuration)*secs)));
    delay(1000);
    secs = (duration - millis())/1000;
    timeLabel.setText("Time remaining: "+secs+"s");
    drawProgress(progress, int(160-(160/float(tDuration)*secs)));
    delay(1000);
  }
  enableButtons(false, false);
  myPort.write("init\n");
}

String getName()
{
  myPort.clear();
  myPort.write("name\n");
  while (myPort.available()==0) {
    delay(5);
  }
  return trim(myPort.readString());
}

void autoRip()
{
  disableButtons();
  myPort.clear();
  abort=false;
  diskChange=false;
  while (abort==false)
  {
    while (diskChange==false && abort==false) {
      myPort.write("dskcng\n");
      while (myPort.available()==0) {
        delay(5);
      }
      delay(1000);
      if (Integer.valueOf(trim(myPort.readString()))==0)
      {
        diskChange = false;
        diskPanel.setVisible(true);
      } else {
        diskChange = true;
        diskPanel.setVisible(false);
      }
    }
    if (abort==true) break;
    myPort.write("init\n");
    myPort.clear();
    delay(200);

    fileName = getName();
    filename.setText(fileName);
    fileName = filePath+fileSep+fileName.replaceAll("[#<>$+%!´`&*\"|{}?=/:\\@]", "_")+"_"+Long.toHexString(System.currentTimeMillis())+".adf";
    filepathandname.setText(fileName);
    myPort.write("init\n");
    myPort.clear();
    delay(200);
    println("Ripping: "+fileName);
    getTracks();
    disableButtons();
    myPort.write("init\n");
    myPort.clear();
    while (diskChange==true && abort==false) {
      delay(1000);
      myPort.write("dskcng\n");
      while (myPort.available()==0) {
        delay(5);
      }
      if (Integer.valueOf(trim(myPort.readString()))==0)
      {
        diskChange = false;
      } else {
        diskChange = true;
        diskPanel.setVisible(true);
      }
    }
  }
  abort = false;
  drawStatus(status, "Aborting by User request...");
  diskPanel.setVisible(false);
  enableButtons(false, false);
}

void setPreErase()
{
  myPort.clear();
  if (preErase) myPort.write("preerase\n");
  else myPort.write("noerase\n");
  delay(5);
  myPort.readString();
  myPort.clear();
}

void autoFormat()
{
  String s = (String)showInputDialog(
    frame, 
    "Diskbasename:\n", 
    "Format several Disks", 
    QUESTION_MESSAGE, null, null, diskName);
  if (s == null) return;
  s = s.substring(0, Math.min(s.length(), 20));
  String diskBaseName=s.replaceAll("[#<>$+%!´`&*\"|{}?=/:\\@]", "_");
  disableButtons();
  myPort.clear();
  myPort.write("nomtp\n");
  myPort.clear();
  setPreErase();
  abort=false;
  diskChange=false;
  int count = 1;
  while (abort==false)
  {
    while (diskChange==false && abort==false) {
      myPort.write("dskcng\n");
      while (myPort.available()==0) {
        delay(5);
      }
      delay(1000);
      if (Integer.valueOf(trim(myPort.readString()))==0)
      {
        diskChange = false;
        diskPanel.setVisible(true);
      } else {
        diskChange = true;
        diskPanel.setVisible(false);
      }
    }
    if (abort==true) break;
    myPort.write("init\n");
    myPort.clear();
    delay(200);
    diskName = diskBaseName + String.format("%04d", count++);
    filename.setText(diskName);
    formatTracks();
    disableButtons();

    myPort.write("init\n");
    myPort.clear();
    while (diskChange==true && abort==false) {
      delay(1000);
      myPort.write("dskcng\n");
      while (myPort.available()==0) {
        delay(5);
      }
      if (Integer.valueOf(trim(myPort.readString()))==0)
      {
        diskChange = false;
      } else {
        diskChange = true;
        diskPanel.setVisible(true);
      }
    }
  }
  abort = false;
  drawStatus(status, "Aborting by User request...");
  diskPanel.setVisible(false);
  enableButtons(false, false);
  myPort.write("mtp\n");
  myPort.clear();
}



int waitForDiskChange()
{
  int diskChange = 0;
  int diskChangeCount = 0;
  myPort.clear();
  while (diskChange==0)
  {
    myPort.write("dskcng\n");
    while (myPort.available()==0) {
      delay(5);
    }
    diskChange = Integer.valueOf(trim(myPort.readString()));
    diskChangeCount++;
    if (diskChangeCount >5) {
      return -1;
    }
  }
  return 1;
}

public class amigaTime {
  private int day, min, ticks;
}


public amigaTime makeTime()
{
  int jm[]={ 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
  int dtmon = month();
  int dtmin = minute();
  int dtsec = second();
  int dthour = hour();
  int dtday = day()-1;
  int dtyear = year();
  amigaTime aTime = new amigaTime();
  aTime.min= dthour*60 + dtmin;                /* mins */
  aTime.ticks= dtsec*50;                        /* ticks */

  /*--- days ---*/

  aTime.day= dtday;                         /* current month days */

  /* previous months days downto january */
  if (dtmon>1) {                      /* if previous month exists */
    dtmon--;
    if (dtmon>2 && Year.isLeap(dtyear))    /* months after a leap february */
      jm[2-1]=29;
    while (dtmon>0) {
      aTime.day=aTime.day+jm[dtmon-1];
      dtmon--;
    }
  }

  /* years days before current year downto 1978 */
  if (dtyear>1978) {
    dtyear--;
    while (dtyear>=1978) {
      if (Year.isLeap(dtyear)){
        aTime.day=aTime.day+366;
      }
      else
        aTime.day=aTime.day+365;
      dtyear--;
    }
  }
  //    println("days: " + aTime.day + " mins: " + aTime.min + " ticks: " + aTime.ticks);
  return aTime;
  //day*86400+min*60;
}


byte [] generateImage(String diskName, boolean HD)
{
  int imageSize;
  if (HD) imageSize = 1802240;
  else imageSize = 901120;
  byte image[] = new byte [imageSize];
  for (int i = 0; i< imageSize; i++) image[i]=0;
  //Bootblock not bootable
  image[0]='D';
  image[1]='O';
  image[2]='S';
  image[3]=0x00;
  int rootBlockPos = 880;
  if (HD) rootBlockPos = 1760;
  //rootblock
  image[rootBlockPos*512+3] =0x02; // Blocktype 2 = RootBlock
  image[rootBlockPos*512+15]=0x48; // Hashtablesize = 72
  image[rootBlockPos*512+0x138]=(byte)0xff;
  image[rootBlockPos*512+0x139]=(byte)0xff;
  image[rootBlockPos*512+0x13a]=(byte)0xff;
  image[rootBlockPos*512+0x13b]=(byte)0xff;  //bitmap flag = -1 -> Valid

  if (HD) { //Bitmap location HD
    image[rootBlockPos*512+0x13e]=(byte)0x06;
    image[rootBlockPos*512+0x13f]=(byte)0xe1;
  } else { //Bitmap location DD
    image[rootBlockPos*512+0x13e]=(byte)0x03;
    image[rootBlockPos*512+0x13f]=(byte)0x71;
  }
  diskName = diskName.substring(0, Math.min(diskName.length(), 30));
  for (int i = 0; i < diskName.length(); i++) {
    image[rootBlockPos*512+0x1b1+i]=(byte)diskName.charAt(i);
  }
  image[rootBlockPos*512+0x1b0]=(byte)diskName.length();
  image[rootBlockPos*512+0x1ff]= 1; //secType
  amigaTime aTime = makeTime();
  //  println("Days: " + aTime.day + " mins: " + aTime.min + " ticks: " + aTime.ticks);

  //creation date FFS and OFS
  image[rootBlockPos*512+0x1a4]=(byte)(byte) (aTime.day>>24 & 0xff); //cDays
  image[rootBlockPos*512+0x1a5]=(byte) (aTime.day>>16 & 0xff);
  image[rootBlockPos*512+0x1a6]=(byte) (aTime.day>>8 & 0xff);
  image[rootBlockPos*512+0x1a7]=(byte) (aTime.day & 0xff);
  image[rootBlockPos*512+0x1a8]=(byte) (aTime.min>>24 & 0xff); //cMins
  image[rootBlockPos*512+0x1a9]=(byte) (aTime.min>>16 & 0xff);
  image[rootBlockPos*512+0x1aa]=(byte) (aTime.min>>8 & 0xff);
  image[rootBlockPos*512+0x1ab]=(byte) (aTime.min & 0xff);
  image[rootBlockPos*512+0x1ac]=(byte) (aTime.ticks>>24 & 0xff); //cTicks
  image[rootBlockPos*512+0x1ad]=(byte) (aTime.ticks>>16 & 0xff);
  image[rootBlockPos*512+0x1ae]=(byte) (aTime.ticks>>8 & 0xff);
  image[rootBlockPos*512+0x1af]=(byte) (aTime.ticks & 0xff);
  // last access
  image[rootBlockPos*512+0x1d8]=(byte) (aTime.day>>24 & 0xff); //Days
  image[rootBlockPos*512+0x1d9]=(byte) (aTime.day>>16 & 0xff);
  image[rootBlockPos*512+0x1da]=(byte) (aTime.day>>8 & 0xff);
  image[rootBlockPos*512+0x1db]=(byte) (aTime.day & 0xff);
  image[rootBlockPos*512+0x1dc]=(byte) (aTime.min>>24 & 0xff); //Mins
  image[rootBlockPos*512+0x1dd]=(byte) (aTime.min>>16 & 0xff);
  image[rootBlockPos*512+0x1de]=(byte) (aTime.min>>8 & 0xff);
  image[rootBlockPos*512+0x1df]=(byte) (aTime.min & 0xff);
  image[rootBlockPos*512+0x1e0]=(byte) (aTime.ticks>>24 & 0xff); //Ticks
  image[rootBlockPos*512+0x1e1]=(byte) (aTime.ticks>>16 & 0xff);
  image[rootBlockPos*512+0x1e2]=(byte) (aTime.ticks>>8 & 0xff);
  image[rootBlockPos*512+0x1e3]=(byte) (aTime.ticks & 0xff);
  // creation date OFS
  image[rootBlockPos*512+0x1e4]=(byte) (aTime.day>>24 & 0xff); //coDays
  image[rootBlockPos*512+0x1e5]=(byte) (aTime.day>>16 & 0xff);
  image[rootBlockPos*512+0x1e6]=(byte) (aTime.day>>8 & 0xff);
  image[rootBlockPos*512+0x1e7]=(byte) (aTime.day & 0xff);
  image[rootBlockPos*512+0x1e8]=(byte) (aTime.min>>24 & 0xff); //coMins
  image[rootBlockPos*512+0x1e9]=(byte) (aTime.min>>16 & 0xff);
  image[rootBlockPos*512+0x1ea]=(byte) (aTime.min>>8 & 0xff);
  image[rootBlockPos*512+0x1eb]=(byte) (aTime.min & 0xff);
  image[rootBlockPos*512+0x1ec]=(byte) (aTime.ticks>>24 & 0xff); //coticks
  image[rootBlockPos*512+0x1ed]=(byte) (aTime.ticks>>16 & 0xff);
  image[rootBlockPos*512+0x1ee]=(byte) (aTime.ticks>>8 & 0xff);
  image[rootBlockPos*512+0x1ef]=(byte) (aTime.ticks & 0xff);

  long newsum = 0;
  for (int i = 0; i < 128; i++)
    newsum += (image[rootBlockPos*512 + i*4] << 24 & 0xff000000)
      | (image[rootBlockPos*512 + i*4 + 1] << 16 & 0x00ff0000)
      | (image[rootBlockPos*512 + i*4 + 2] << 8 & 0x0000ff00)
      | (image[rootBlockPos*512 + i*4 + 3] & 0x000000ff);
  newsum = (int)-newsum;
  image[rootBlockPos*512+0x14]=(byte) (newsum>>24 & 0xff);
  image[rootBlockPos*512+0x15]=(byte) (newsum>>16 & 0xff);
  image[rootBlockPos*512+0x16]=(byte) (newsum>>8 & 0xff);
  image[rootBlockPos*512+0x17]=(byte) (newsum & 0xff);

  // construction of bitmap block
  for (int i = 4; i < 512; i++) {
    image[(rootBlockPos+1)*512+i]=-1;
  }
  if (HD) {
    image[(rootBlockPos+1)*512+220]=0x3f;
  } else {
    image[(rootBlockPos+1)*512+114]=0x3f;
  }
  newsum = 0;
  int tempSum = 0;
  int blockPtr = (rootBlockPos+1)*512;
  for (int i = 0; i < 128; i++) {
    tempSum =  (image[blockPtr + i*4] << 24 & 0xff000000)
      | (image[blockPtr + i*4 + 1] << 16 & 0x00ff0000)
      | (image[blockPtr + i*4 + 2] <<  8 & 0x0000ff00)
      | (image[blockPtr + i*4 + 3]       & 0x000000ff);
    newsum = newsum + tempSum;
  }
  newsum = (int)-newsum;
  image[(rootBlockPos+1)*512+0x00]=(byte) (newsum>>24 & 0xff);
  image[(rootBlockPos+1)*512+0x01]=(byte) (newsum>>16 & 0xff);
  image[(rootBlockPos+1)*512+0x02]=(byte) (newsum>>8 & 0xff);
  image[(rootBlockPos+1)*512+0x03]=(byte) (newsum & 0xff);
  return image;
}


void formatTracks()
{
  boolean quick = quickFormat.isSelected();
  if (!autoFormatDisks) {
    String s = (String)showInputDialog(
      frame, 
      "Diskname:\n", 
      "Format Disk", 
      QUESTION_MESSAGE, null, null, diskName);
    if (s == null) return;
    s = s.substring(0, Math.min(s.length(), 30));
    diskName=s.replaceAll("[#<>$+%!´`&*\"|{}?=/:\\@]", "_");
  }
  int retries= 0;
  verify=verifyCheck.isSelected();
  setPreErase();
  abort = false;
  disableButtons();
  myPort.clear();
  for (int i = 0; i<160; i++)
  {
    weak[i]=0;
    errormap[i]=0;
    trackmap[i]=#ffffff;
    for ( int j=0; j<256; j++) {
      hist[i][j]=0;
    }
  }
  drawFlux(flux);
  int start = 0;
  int stop = 160;
  int zeit = millis();
  long errors = 0;
  int failed = 0;
  String tempString;
  boolean retry = false;
  int trackSize = 5632;
  boolean HDImage = false;
  switch (probeDisk()) {
  case 1: //DD
    HDImage = false;
    break;
  case 2: //HD
    HDImage = true;
    break;
  case -1: //write protected
    drawStatus(status, "Disk is write protected.");
    showMessageDialog(frame, "Disk is write protected.", "Information", INFORMATION_MESSAGE);
    enableButtons(false, true);
    return;
  default:
    drawStatus(status, "faulty Disk.");
    showMessageDialog(frame, "Magnetic surface of the Disk is faulty.", "Information", INFORMATION_MESSAGE);
    enableButtons(false, true);
    return;
  }

  byte image[] = generateImage(diskName, HDImage);
  int imageSize = image.length;
  //imageSize=0;
  switch (imageSize) {
  case 901120:
    HDImage = false;
    trackSize = 5632;
    break;
  case 1802240:
    HDImage = true;
    trackSize = 2*5632;
    if (HD_allowed) break;
    drawStatus(status, "Formattting HD isn't implemented yet.");
    showMessageDialog(frame, "Formattting HD Images isn't implemented yet.", "Information", INFORMATION_MESSAGE);
    enableButtons(false, true);
    return;
  default:    
    drawStatus(status, "Wrong Image size");
    showMessageDialog(frame, "Wrong Image Size", "Error", ERROR_MESSAGE);
    enableButtons(false, false);
    return;
  }
  byte track[] = new byte[trackSize];
  byte trackComp[] = new byte[trackSize];
  Arrays.fill(track, (byte)0);
  Arrays.fill(trackComp, (byte)0);

  drawStatus(status, "Writing Tracks");
  myPort.write("init\n");
  delay(100);
  waitForDiskChange();
  if (HDImage) {
    myPort.write("setmode hd\n");
  } else {
    myPort.write("setmode dd\n");
  }
  while (myPort.available()<2) {
    delay(5);
  }
  tempString = trim(myPort.readString());
  for (int i = start; i<stop; i++) {
    if (i==1 && quick) i=80;
    if (i==81 && quick) {
      drawProgress(progress, 159);
      break;
    }
    if (abort==true) {
      abort = false;
      drawStatus(status, "Aborting by User request...");
      break;
    }
    waitForDiskChange();
    if (HDImage) {
      arrayCopy(image, i*512*22, track, 0, 512*22);
      myPort.write("upload\n");
      myPort.write(track);
      while (myPort.available()<2) {
        delay(5);
      }
      tempString = trim(myPort.readString());
    } else {
      arrayCopy(image, i*512*11, track, 0, 512*11);
      myPort.write("upload\n");
      myPort.write(track);
      while (myPort.available()<2) {
        delay(5);
      }
      tempString = trim(myPort.readString());
    }
    myPort.write("put "+i+"\n");
    //    delay(250);
    while (myPort.available()==0) {
      delay(5);
    }
    tempString = trim(myPort.readString());
    if (tempString.contains("OK")) {
      trackmap[i]=#0000ff;
      grid(upperGrid, 0);
      grid(lowerGrid, 1);
    }
    drawProgress(progress, i);
    myPort.write("error\n");
    while (myPort.available()==0) {
      delay(5);
    }
    tempString = trim(myPort.readString());
    errors = Long.parseLong(tempString);
    if (errors==-1) {
      drawStatus(status, getExtErr()+" Aborting...");
      failed = -1;
      break;
    }
    if (verify) {
      myPort.write("get "+i+"\n");
      myPort.write("download\n");
      while (myPort.available()<trackSize) {
        delay(10);
      }
      trackComp = myPort.readBytes();
      getWeak(i);
      getFlux(i);
      drawFlux(flux);
      if (!Arrays.equals(track, trackComp)) {
        trackmap[i]=#ff0000;
        retry = true;
        retries++;
      } else {
        trackmap[i]=#00ff00;
        retries=0;
      }
      grid(upperGrid, 0);
      grid(lowerGrid, 1);
    }
    drawStatus(status, "Track: " + i + " Retries: " + retries);
    if (retries>10) {
      if (showConfirmDialog(frame, "Retry?", "Write error at Track "+i, YES_NO_OPTION)==1)
      {
        drawStatus(status, "Track " + i+" is unwritable. Aborting...");
        failed = -1;
        break;
      } else {
        retries = 0;
      }
    }
    timeLabel.setText("Time remaining: "+((millis()-zeit)*160/(i+1)-(millis()-zeit))/1000+"s");
    if (retry) {
      i--;
      retry = false;
    }
  }
  zeit = millis()-zeit;
  if (failed == 0) {
    drawStatus(status, "Format completed in "+(zeit/1000)+" Seconds");
    timeLabel.setText("Done");
  } else {
    timeLabel.setText("Error");
  }   
  if (!autoFormatDisks) diskInfo(false);
  enableButtons(false, false);
  myPort.write("init\n");
  drawActive(active, 2);
}

void eraseTracks()
{
  abort = false;
  disableButtons();
  myPort.clear();
  for (int i = 0; i<160; i++)
  {
    weak[i]=0;
    errormap[i]=0;
    trackmap[i]=#ffffff;
    for ( int j=0; j<256; j++) {
      hist[i][j]=0;
    }
  }
  drawFlux(flux);
  int start = 0;
  int stop = 160;
  int zeit = millis();
  int failed = 0;
  String tempString;
  boolean HDdisk = false;
  switch (probeDisk()) {
  case 1: //DD
    HDdisk = false;
    break;
  case 2: //HD
    HDdisk = true;
    break;
  case -1: //write protected
    drawStatus(status, "Disk is write protected.");
    showMessageDialog(frame, "Disk is write protected.", "Information", INFORMATION_MESSAGE);
    enableButtons(false, true);
    return;
  default:
    drawStatus(status, "faulty Disk.");
    showMessageDialog(frame, "Magnetic surface of the Disk is faulty.", "Information", INFORMATION_MESSAGE);
    enableButtons(false, true);
    return;
  }

  drawStatus(status, "Erasing Tracks");
  myPort.write("init\n");
  delay(100);
  for (int i = start; i<stop; i++) {
    if (abort==true) {
      abort = false;
      drawStatus(status, "Aborting by User request...");
      break;
    }
    myPort.clear();
    if (HDdisk) myPort.write("erase " + i + " 200\n");
    else myPort.write("erase " + i + " 400\n");
    while (myPort.available()<2) {
      delay(5);
    }
    tempString = trim(myPort.readString());
    if (tempString.contains("OK")) {
      trackmap[i]=#ff00ff;
      grid(upperGrid, 0);
      grid(lowerGrid, 1);
    }
    drawProgress(progress, i);
    drawStatus(status, "Track: " + i);
    timeLabel.setText("Time remaining: "+((millis()-zeit)*160/(i+1)-(millis()-zeit))/1000+"s");
  }
  zeit = millis()-zeit;
  if (failed == 0) {
    drawStatus(status, "Erase completed in "+(zeit/1000)+" Seconds");
    timeLabel.setText("Done");
  } else {
    timeLabel.setText("Error");
  }   
  enableButtons(false, false);
  myPort.write("init\n");
  drawActive(active, 2);
}

void putTracks()
{
  int retries= 0;
  setPreErase();
  verify=verifyCheck.isSelected();
  abort = false;
  disableButtons();
  myPort.clear();
  for (int i = 0; i<160; i++)
  {
    weak[i]=0;
    errormap[i]=0;
    trackmap[i]=#ffffff;
    for ( int j=0; j<256; j++) {
      hist[i][j]=0;
    }
  }
  drawFlux(flux);
  int start = 0;
  int stop = 160;
  int zeit = millis();
  long errors = 0;
  int failed = 0;
  String tempString;
  boolean retry = false;
  int trackSize = 5632;
  byte image[] = loadBytes(fileName);
  if (image==null) {
    drawStatus(status, "Error reading Image");
    enableButtons(false, false);
    return;
  }
  boolean HDImage = false;
  int imageSize = image.length;
  switch (imageSize) {
  case 901120:
    HDImage = false;
    trackSize = 5632;
    break;
  case 1802240:
    HDImage = true;
    trackSize = 2*5632;
    if (HD_allowed) break;
    drawStatus(status, "Writing HD isn't implemented yet.");
    showMessageDialog(frame, "Writing HD Images isn't implemented yet.", "Information", INFORMATION_MESSAGE);
    enableButtons(false, true);
    return;
  default:    
    drawStatus(status, "Wrong Image size");
    showMessageDialog(frame, "Wrong Image Size", "Error", ERROR_MESSAGE);
    enableButtons(false, false);
    return;
  }
  byte track[] = new byte[trackSize];
  byte trackComp[] = new byte[trackSize];
  Arrays.fill(track, (byte)0);
  Arrays.fill(trackComp, (byte)0);

  drawStatus(status, "Writing Tracks");
  myPort.write("init\n");
  delay(100);
  waitForDiskChange();
  if (HDImage) {
    myPort.write("setmode hd\n");
  } else {
    myPort.write("setmode dd\n");
  }
  while (myPort.available()<2) {
    delay(5);
  }
  tempString = trim(myPort.readString());
  for (int i = start; i<stop; i++) {
    if (abort==true) {
      abort = false;
      drawStatus(status, "Aborting by User request...");
      break;
    }
    waitForDiskChange();
    if (HDImage) {
      arrayCopy(image, i*512*22, track, 0, 512*22);
      myPort.write("upload\n");
      myPort.write(track);
      while (myPort.available()<2) {
        delay(5);
      }
      tempString = trim(myPort.readString());
    } else {
      arrayCopy(image, i*512*11, track, 0, 512*11);
      myPort.write("upload\n");
      myPort.write(track);
      while (myPort.available()<2) {
        delay(5);
      }
      tempString = trim(myPort.readString());
    }
    myPort.write("put "+i+"\n");
    //    delay(250);
    while (myPort.available()==0) {
      delay(5);
    }
    tempString = trim(myPort.readString());
    if (tempString.contains("OK")) {
      trackmap[i]=#0000ff;
      grid(upperGrid, 0);
      grid(lowerGrid, 1);
    }
    drawProgress(progress, i);
    myPort.write("error\n");
    while (myPort.available()==0) {
      delay(5);
    }
    tempString = trim(myPort.readString());
    errors = Long.parseLong(tempString);
    if (errors==-1) {
      drawStatus(status, getExtErr()+" Aborting...");
      failed = -1;
      break;
    }
    if (verify) {
      myPort.write("get "+i+"\n");
      myPort.write("download\n");
      while (myPort.available()<trackSize) {
        delay(10);
      }
      trackComp = myPort.readBytes();
      getWeak(i);
      getFlux(i);
      drawFlux(flux);
      if (!Arrays.equals(track, trackComp)) {
        trackmap[i]=#ff0000;
        retry = true;
        retries++;
      } else {
        trackmap[i]=#00ff00;
        retries=0;
      }
      grid(upperGrid, 0);
      grid(lowerGrid, 1);
    }
    drawStatus(status, "Track: " + i + " Retries: " + retries);
    if (retries>10) {
      if (showConfirmDialog(frame, "Retry?", "Write error at Track "+i, YES_NO_OPTION)==1)
      {
        drawStatus(status, "Track " + i+" is unwritable. Aborting...");
        failed = -1;
        break;
      } else {
        retries = 0;
      }
    }
    timeLabel.setText("Time remaining: "+((millis()-zeit)*160/(i+1)-(millis()-zeit))/1000+"s");
    if (retry) {
      i--;
      retry = false;
    }
  }
  zeit = millis()-zeit;
  if (failed == 0) {
    drawStatus(status, "Write complete. "+(stop-start)+" Tracks written in "+(zeit/1000)+" Seconds");
    timeLabel.setText("Done");
    diskInfo(false);
  } else {
    timeLabel.setText("Error");
  }
  diskInfo(false);
  enableButtons(false, true);
  myPort.write("init\n");
}

void compareSelected(File selection) {
  if (selection == null) {
    println("Window was closed or the user hit cancel.");
  } else {
    println("User selected " + selection.getAbsolutePath());
    fileName=selection.getAbsolutePath();
    filepathandname.setText(fileName);
    thread("compareDisk");
  }
}

void compareDisk()
{
  abort = false;
  disableButtons();
  myPort.clear();
  for (int i = 0; i<160; i++)
  {
    weak[i]=0;
    errormap[i]=0;
    trackmap[i]=#ffffff;
    for ( int j=0; j<256; j++) {
      hist[i][j]=0;
    }
  }
  drawFlux(flux);
  int start = 0;
  int stop = 160;
  int zeit = millis();
  long errors = 0;
  int failed = 0;
  String tempString;
  int trackSize = 5632;
  byte image[] = loadBytes(fileName);
  if (image==null) {
    drawStatus(status, "Error reading Image");
    enableButtons(false, false);
    return;
  }
  boolean HDImage = false;
  int imageSize = image.length;
  switch (imageSize) {
  case 901120:
    HDImage = false;
    trackSize = 5632;
    break;
  case 1802240:
    HDImage = true;
    trackSize = 2*5632;
    if (HD_allowed) break;
    drawStatus(status, "Writing HD isn't implemented yet.");
    showMessageDialog(frame, "Writing HD Images isn't implemented yet.", "Information", INFORMATION_MESSAGE);
    enableButtons(false, true);
    return;
  default:    
    drawStatus(status, "Wrong Image size");
    showMessageDialog(frame, "Wrong Image Size", "Error", ERROR_MESSAGE);
    enableButtons(false, false);
    return;
  }
  byte track[] = new byte[trackSize];
  byte trackComp[] = new byte[trackSize];
  Arrays.fill(track, (byte)0);
  Arrays.fill(trackComp, (byte)0);

  drawStatus(status, "Comparing Tracks");
  myPort.write("init\n");
  delay(100);
  waitForDiskChange();
  if (HDImage) {
    myPort.write("setmode hd\n");
  } else {
    myPort.write("setmode dd\n");
  }
  while (myPort.available()<2) {
    delay(5);
  }
  tempString = trim(myPort.readString());
  for (int i = start; i<stop; i++) {
    if (abort==true) {
      abort = false;
      drawStatus(status, "Aborting by User request...");
      break;
    }
    waitForDiskChange();
    if (HDImage) {
      arrayCopy(image, i*512*22, track, 0, 512*22);
    } else {
      arrayCopy(image, i*512*11, track, 0, 512*11);
    }
    drawProgress(progress, i);
    myPort.write("error\n");
    while (myPort.available()==0) {
      delay(5);
    }
    tempString = trim(myPort.readString());
    errors = Long.parseLong(tempString);
    if (errors==-1) {
      drawStatus(status, getExtErr()+" Aborting...");
      failed = -1;
      break;
    }
    {
      myPort.write("get "+i+"\n");
      myPort.write("download\n");
      while (myPort.available()<trackSize) {
        delay(10);
      }
      trackComp = myPort.readBytes();
      getWeak(i);
      getFlux(i);
      drawFlux(flux);
      if (!Arrays.equals(track, trackComp)) {
        trackmap[i]=#ff0000;
      } else {
        if (weak[i]==0) trackmap[i]=#00ff00;
        else trackmap[i]=#ffff00;
      }
      grid(upperGrid, 0);
      grid(lowerGrid, 1);
    }
    drawStatus(status, "Track: " + i + " Retries: " + weak[i]);
    timeLabel.setText("Time remaining: "+((millis()-zeit)*160/(i+1)-(millis()-zeit))/1000+"s");
  }
  zeit = millis()-zeit;
  if (failed == 0) {
    drawStatus(status, "Compare complete. "+(stop-start)+" Tracks compared in "+(zeit/1000)+" Seconds");
    timeLabel.setText("Done");
  } else {
    timeLabel.setText("Error");
  }    
  enableButtons(false, true);
  myPort.write("init\n");
}

void printBuffer() {
  for (int k = 0; k < 11; k++) {
    println("Sector "+k);
    for (int i = 0; i < 16; i++) {
      for (int j = 0; j < 32; j++) {
        System.out.printf("%02x", track[(i*32)+j+k*512]);
      }
      print(" ");
      for (int j = 0; j < 32; j++) {
        System.out.printf("%c", byte2char(track[(i*32)+j+k*512]));
      }
      println();
    }
  }
}

String parseError(long error)
{
  String tError="";
  if ((error&0xffffffff)!=0) {
    tError = " HeaderChkSum fail in Sector: ";
  }
  for (int i =0; i<32; i++) {
    if ((error&1)==1)
    {
      tError+=i+" ";
    }
    error=error>>1;
  }
  if ((error)!=0) {
    tError+=" DataChkSum fail in Sector: ";
  }
  for (int i =0; i<32; i++) {
    if ((error&1)==1)
    {
      tError+=i+" ";
    }
    error=error>>1;
  }
  return tError;
}

void initSerial()
{
  surface.setTitle(version+": Loading Native Serial Library");
  String osName = System.getProperty("os.name");
  String osArch = System.getProperty("os.arch");
  String libName = "";
  String osVersion = System.getProperty("os.version");
  fileSep = System.getProperty("file.separator");
  println(osName + " " + osArch + " " + osVersion);
  if (osName.startsWith("Win")) {
    if (osArch.equals("i386") || osArch.equals("i686") || osArch.equals("x86")) {
      libName=fileSep+"jSSC-2.8_x86.dll";
      version = version +" - "+osName+" 32 bit";
    } else if (osArch.equals("amd64") || osArch.equals("universal")) {
      libName=fileSep+"jSSC-2.8_x86_64.dll";
      version = version +" - "+osName+" 64 bit";
    }
  } else {
    if (osArch.equals("arm")) {
      libName=fileSep+"libjSSC-2.8_arm.so";
      version = version +" - "+ osName + " ARM "+osVersion;
    }
  }
  if (osName.startsWith("Linux")) {
    if (osArch.equals("i386") || osArch.equals("i686") || osArch.equals("x86")) {
      libName=fileSep+"libjSSC-2.8_linux32.so";
      version = version +" - "+osName+" 32 bit";
    } else if (osArch.equals("amd64") || osArch.equals("universal")) {
      libName=fileSep+"libjSSC-2.8_linux64.so";
      version = version +" - "+osName+" 64 bit";
    }
  }

  try {
    System.load(dataPath("")+libName);
  } 
  catch (UnsatisfiedLinkError e) {
    System.err.println("Native code library failed to load.\n" + e);
    version = version +".";
    showMessageDialog(frame, "Unsupported System: "+osName+" "+osArch+" "+osVersion);
    System.exit(0);
  }
  println("Loaded "+dataPath("")+libName);
  surface.setTitle(version+": Searching COM-Port");
  String COMx, COMlist = "";
  try {
    int i = Serial.list().length;
    if (i != 0) {
      if (i >= 2) {
        for (int j = 0; j < i; j++ ) {
          if (osName.startsWith("Win")) {

            COMlist += char(j+'a') + " = " + Serial.list()[j];
            //println(Serial.list()[j]);
            if (j < i) COMlist += ",  ";
          } else {
            if (Serial.list()[j].startsWith("/dev/ttyACM")) {
              COMlist += char(j+'a') + " = " + Serial.list()[j];
              //println(Serial.list()[j]);
              if (j < i) COMlist += ",  ";
            }
          }
        }
        if (COMlist.endsWith(",  ")) {
          COMlist = COMlist.substring(0, COMlist.length()-3);
        }
        COMx = showInputDialog("Which COM port is correct? (a,b,..):\n"+COMlist);
        if (COMx == null) exit();
        else if (COMx.isEmpty()) exit(); 
        else
          i = int(COMx.toLowerCase().charAt(0) - 'a') + 1;
      }
      String portName = Serial.list()[i-1];
      pName = portName;
      myPort = new Serial(this, portName, 230400);
    } else {
      showMessageDialog(frame, "Device is not connected to the PC,\ndisabling most functions.");
      //System.exit(0);
    }
  }
  catch (Exception e)
  { //Print the type of error
    showMessageDialog(frame, "COM port is not available (may\nbe in use by another program),\ndisabling most functions.");
    println("Error:", e);
    //System.exit(0);
  }
}
